#ifndef BOUNDARY_HPP_
#define BOUNDARY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// STL headers
#include <map>

#include "config.hpp"
#include "linkedcell.hpp"
#include "molecules.hpp"
#include "tesselation.hpp"

#define DEBUG 1
#define DoSingleStepOutput 1
#define SingleStepWidth 1

#define DistancePair pair < double, atom* >
#define DistanceMap multimap < double, atom* >
#define DistanceTestPair pair < DistanceMap::iterator, bool>

#define Boundaries map <double, DistancePair >
#define BoundariesPair pair<double, DistancePair >
#define BoundariesTestPair pair< Boundaries::iterator, bool>

double VolumeOfConvexEnvelope(ofstream *out, class Tesselation *TesselStruct, class config *configuration);
double * GetDiametersOfCluster(ofstream *out, Boundaries *BoundaryPtr, molecule *mol, bool IsAngstroem);
void PrepareClustersinWater(ofstream *out, config *configuration, molecule *mol, double ClusterVolume, double celldensity);
molecule * FillBoxWithMolecule(ofstream *out, MoleculeListClass *List, molecule *filler, config &configuration, double distance[NDIM], double RandAtomDisplacement, double RandMolDisplacement, bool DoRandomRotation);
void FindConvexBorder(ofstream *out, molecule* mol, class LinkedCell *LCList, const char *filename);
void FindNonConvexBorder(ofstream *out, molecule* mol, class LinkedCell *LC, const double RADIUS, const char *tempbasename);
double ConvexizeNonconvexEnvelope(ofstream *out, class Tesselation *TesselStruct, molecule *mol, char *filename);
void FindNextSuitablePoint(class BoundaryTriangleSet *BaseTriangle, class BoundaryLineSet *BaseLine, atom*& OptCandidate, Vector *OptCandidateCenter, double *ShortestAngle, const double RADIUS, LinkedCell *LC);
Boundaries *GetBoundaryPoints(ofstream *out, molecule *mol);
void CalculateConcavityPerBoundaryPoint(ofstream *out, class Tesselation *TesselStruct);
void StoreTrianglesinFile(ofstream *out, molecule *mol, const char *filename, const char *extraSuffix);
bool RemoveAllBoundaryPoints(ofstream *out, class Tesselation *TesselStruct, molecule *mol, char *filename);


#endif /*BOUNDARY_HPP_*/
