/** \file FormatParserStorage.hpp
 *
 *  date: Jun, 22 2010
 *  author: heber
 *
 */

#ifndef FORMATPARSERSTORAGE_HPP_
#define FORMATPARSERSTORAGE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Patterns/Singleton.hpp"

#include <string>
#include <vector>

class FormatParser;
class MpqcParser;
class PcpParser;
class TremoloParser;
class XyzParser;

// enum has to be outside of class for operator++ to be possible
enum ParserTypes { mpqc, pcp, tremolo, xyz, ParserTypes_end, ParserTypes_begin = mpqc };
typedef enum ParserTypes ParserTypes;

ParserTypes &operator++(ParserTypes &type);

class FormatParserStorage : public Singleton<FormatParserStorage> {
  friend class Singleton<FormatParserStorage>;
public:


  void addMpqc();
  void addPcp();
  void addTremolo();
  void addXyz();

  MpqcParser &getMpqc();
  PcpParser &getPcp();
  TremoloParser &getTremolo();
  XyzParser &getXyz();

  void SetOutputPrefixForAll(std::string &_prefix);
  void SaveAll();

private:
  // private constructors as this is a singleton
  FormatParserStorage();
  ~FormatParserStorage();
  
  // list of allocated parsers
  std::vector<FormatParser *> ParserList;

  // list of allocated strams
  std::vector<std::ofstream *> ParserStream;

  // which parser is already present
  std::vector<bool> ParserPresent;

  // default suffix of each parser type
  std::vector<std::string> ParserSuffix;

  // prefix of the filenames to use on save
  std::string prefix;
};

#endif // FORMATPARSERSTORAGE_HPP_
