/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2017 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * GeometryPositionToVectorAction.cpp
 *
 *  Created on: Mar 27, 2017
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"

#include <string>

#include "Atom/atom.hpp"
#include "Geometry/GeometryObject.hpp"
#include "Geometry/GeometryRegistry.hpp"
#include "World.hpp"

#include "Actions/GeometryAction/GeometryPositionToVectorAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "../GeometryAction/GeometryPositionToVectorAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr GeometryPositionToVectorAction::performCall() {
  // check preconditions
  World& world = World::getInstance();
  if (world.countSelectedAtoms() != 1) {
    STATUS("There must be exactly one atom selected for GeometryAction PositionToVector.");
    return Action::failure;
  }
  if (GeometryRegistry::getInstance().isPresentByName(params.name.get())) {
    STATUS("Name "+params.name.get()+" already present in registry.");
    return Action::failure;
  }

  const atom * const Walker = world.beginAtomSelection()->second;
  const Vector position = Walker->getPosition();
  const GeometryObject vec(position, params.name.get());
  LOG(4, "DEBUG: Adding geometry object " << vec << " with norm " << position.Norm());
  GeometryRegistry::getInstance().addGeometry(vec);

  GeometryPositionToVectorState *UndoState = new GeometryPositionToVectorState(position, params);
  return ActionState::ptr(UndoState);
}

ActionState::ptr GeometryPositionToVectorAction::performUndo(ActionState::ptr _state) {
//  GeometryPositionToVectorState *state = assert_cast<GeometryPositionToVectorState*>(_state.get());

  GeometryRegistry::getInstance().removeGeometry(params.name.get());

  return ActionState::ptr(_state);
}

ActionState::ptr GeometryPositionToVectorAction::performRedo(ActionState::ptr _state){
  GeometryPositionToVectorState *state = assert_cast<GeometryPositionToVectorState*>(_state.get());

  const GeometryObject vec(state->position, params.name.get());
  LOG(4, "DEBUG: Adding geometry object " << vec);
  GeometryRegistry::getInstance().addGeometry(vec);

  return ActionState::ptr(_state);
}

bool GeometryPositionToVectorAction::canUndo() {
  return true;
}

bool GeometryPositionToVectorAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
