/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2017 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * GeometryInputToVectorAction.cpp
 *
 *  Created on: Mar 28, 2017
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"

#include <string>

#include "Geometry/GeometryObject.hpp"
#include "Geometry/GeometryRegistry.hpp"

#include "Actions/GeometryAction/GeometryInputToVectorAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "../GeometryAction/GeometryInputToVectorAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr GeometryInputToVectorAction::performCall() {
  // check preconditions
  if (GeometryRegistry::getInstance().isPresentByName(params.name.get())) {
    STATUS("Name "+params.name.get()+" already present in registry.");
    return Action::failure;
  }

  const GeometryObject vec(params.vec.get(), params.name.get());
  LOG(4, "DEBUG: Adding geometry object " << vec << " with norm " << params.vec.get().Norm());
  GeometryRegistry::getInstance().addGeometry(vec);

  return Action::success;
}

ActionState::ptr GeometryInputToVectorAction::performUndo(ActionState::ptr _state) {
//  GeometryInputToVectorState *state = assert_cast<GeometryInputToVectorState*>(_state.get());

  GeometryRegistry::getInstance().removeGeometry(params.name.get());

  return Action::success;
}

ActionState::ptr GeometryInputToVectorAction::performRedo(ActionState::ptr _state){
//  GeometryInputToVectorState *state = assert_cast<GeometryInputToVectorState*>(_state.get());

  const GeometryObject vec(params.vec.get(), params.name.get());
  LOG(4, "DEBUG: Adding geometry object " << vec);
  GeometryRegistry::getInstance().addGeometry(vec);

  return Action::success;
}

bool GeometryInputToVectorAction::canUndo() {
  return true;
}

bool GeometryInputToVectorAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
