/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorsCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <vector>

#include "Actions/Values.hpp"
#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

CommandLineDialog::VectorsCommandLineQuery::VectorsCommandLineQuery(string title, bool _check, string _description) :
    Dialog::VectorsQuery(title,_check, _description)
{}

CommandLineDialog::VectorsCommandLineQuery::~VectorsCommandLineQuery()
{}

bool CommandLineDialog::VectorsCommandLineQuery::handle() {
  std::vector<VectorValue> temporary;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    temporary = CommandLineParser::getInstance().vm[getTitle()].as< std::vector<VectorValue> >();
    for(std::vector<VectorValue>::iterator iter = temporary.begin(); iter != temporary.end(); ++iter) {
      temp[0] = (*iter).x;
      temp[1] = (*iter).y;
      temp[2] = (*iter).z;
      if ((!check) || (World::getInstance().getDomain().isInside(temp)))
        tmp.push_back(temp);
      else
        DoeLog(1) && (eLog() << Verbose(1) << "Vector " << temp << " would be outside of box domain." << endl);
    }
    return true;
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "CommandLineUI parsing error: Missing vectors for " << getTitle() << "." << endl);
    return false;
  }
}

