/*
 * Eigenvalues.hpp
 *
 *  Created on: Mar 8, 2013
 *      Author: heber
 */

#ifndef EIGENVALUES_HPP_
#define EIGENVALUES_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <set>
#include <vector>

class Eigenvalues
{
public:
  //!> named type for a vector of sample values
  typedef std::vector<double> samples_t;
  //!> grant output operator access
  friend std::ostream & operator<<(std::ostream &ost, const Eigenvalues &eigenvalues);
public:
  /** Default constructor for class Eigenvalues.
   *
   */
  Eigenvalues()
  {}

  /** Constructor with a given vector of eigenvalues.
   *
   * \param _samples set of eigenvalues
   */
  Eigenvalues(const samples_t &_samples)
  {
    samples.insert(_samples.begin(), _samples.end());
  }

  /** Default destructor for Eigenvalues.
   *
   */
  ~Eigenvalues()
  {}

  /** Adding another set of eigenvalues onto this one.
   *
   *
   * @param other other Eigenvalues
   * @return ref to this instance
   */
  Eigenvalues& operator+=(const Eigenvalues &other) {
    superposeOtherEigenvalues(other, +1.);
    return *this;
  }

  /** Subtracting another set of eigenvalues from this one.
   *
   * @param other other Eigenvalues
   * @return ref to this instance
   */
  Eigenvalues& operator-=(const Eigenvalues &other) {
    superposeOtherEigenvalues(other, -1.);
    return *this;
  }

private:
  /** Helper function that contains all the logic of how to superpose two
   * sets of eigenvalues.
   *
   * Is called by Eigenvalues::operator+=() and Eigenvalues::operator-=()
   *
   * @param other other Eigenvalues
   * @param prefactor +1. is then addition, -1. is subtraction.
   */
  void superposeOtherEigenvalues(const Eigenvalues &other, const double prefactor);

private:
  //!> typedef for the internal container format
  typedef std::set<double> sorted_samples_t;
  //!> internally we store a set of sorted samples
  sorted_samples_t samples;
};

/** Function to print eigenvalues to ostream.
 *
 * @param ost output stream
 * @param eigenvalues set of eigenvalues to print
 * @return ref to given ostream for concatenation
 */
std::ostream & operator<<(std::ostream &ost, const Eigenvalues &eigenvalues);

template<typename T> T ZeroInstance();
template<> Eigenvalues ZeroInstance<Eigenvalues>();

#endif /* EIGENVALUES_HPP_ */
