/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2013 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Eigenvalues.cpp
 *
 *  Created on: Mar 8, 2013
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Eigenvalues.hpp"

#include <iostream>

void Eigenvalues::superposeOtherEigenvalues(const Eigenvalues &other, const double prefactor)
{
  for (sorted_samples_t::const_iterator otheriter = other.samples.begin();
      otheriter != other.samples.end();
      ++otheriter) {
    sorted_samples_t::iterator iter = samples.find(*otheriter);
    if (iter == samples.end())
      samples.insert((*otheriter));
    else
      samples.erase(iter);
  }
}

std::ostream & operator<<(std::ostream &ost, const Eigenvalues &eigenvalues)
{
  for (Eigenvalues::sorted_samples_t::const_iterator iter = eigenvalues.samples.begin();
      iter != eigenvalues.samples.end(); ++iter)
    ost << "(" << *iter << ",1.) ";
  return ost;
}

template<> Eigenvalues ZeroInstance<Eigenvalues>()
{
  Eigenvalues returnvalue;
  return returnvalue;
}
