/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * QtElementList.cpp
 *
 *  Created on: Mar 6, 2012
 *      Author: ankele
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Views/Qt4/QtElementList.hpp"

#include <iostream>

#include "CodePatterns/MemDebug.hpp"

#include "Atom/atom.hpp"
#include "Formula.hpp"
#include "molecule.hpp"
#include "MoleculeListClass.hpp"

#include "Element/element.hpp"
#include "Element/periodentafel.hpp"
#include "Descriptors/AtomTypeDescriptor.hpp"
#include <QAbstractItemView>

using namespace std;

const int QtElementList::COLUMNCOUNT = COLUMNTYPES_MAX;
const char *QtElementList::COLUMNNAMES[QtElementList::COLUMNCOUNT]={"Number","Name","Symbol","Mass","Occurrence"};

QtElementList::QtElementList(QWidget * _parent) :
    QTreeWidget (_parent),
    Observer("QtElementList")
{
  setColumnCount(COLUMNCOUNT);
  setSelectionMode(QAbstractItemView::MultiSelection);

  QStringList header;
	for(int i=0; i<COLUMNCOUNT;++i)
	  header << COLUMNNAMES[i];
	setHeaderLabels(header);

	molecules = World::getInstance().getMolecules();
	molecules->signOn(this);
	update(molecules);

	connect(this,SIGNAL(cellClicked(int,int)),this,SLOT(cellSelected(int,int)));
}

QtElementList::~QtElementList()
{
	molecules->signOff(this);
}

void QtElementList::update(Observable *publisher) {

  periodentafel *&periode = World::getInstance().getPeriode();


  int i;

  clear();
  periodentafel::const_iterator iter;
  for(iter = periode->begin(),i=0;
      iter != periode->end();
      ++i,++iter) {
    const element *e = iter->second;
    int count = 0;
    count = World::getInstance().getAllAtoms(AtomByType(e)).size();

    QTreeWidgetItem *treeItem = new QTreeWidgetItem(this);
    treeItem->setText(0, QString::number(e->getAtomicNumber()));
    treeItem->setText(1, QString(e->getName().c_str()));
    treeItem->setText(2, QString(e->getSymbol().c_str()));
    treeItem->setText(3, QString::number(e->getMass()));
    if (count > 0){
      treeItem->setText(4, QString::number(count));
    }else{
      treeItem->setText(4, "none");
      treeItem->setDisabled(true);
    }
  }
}

void QtElementList::subjectKilled(Observable *publisher) {
}


void QtElementList::cellSelected(int row, int column)
{
}

