/*
 * AnalysisPairCorrelationUnitTest.cpp
 *
 *  Created on: Oct 13, 2009
 *      Author: heber
 */

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <cstring>

#include "analysis_correlation.hpp"
#include "AnalysisPairCorrelationUnitTest.hpp"

#include "World.hpp"
#include "atom.hpp"
#include "boundary.hpp"
#include "element.hpp"
#include "molecule.hpp"
#include "linkedcell.hpp"
#include "periodentafel.hpp"
#include "tesselation.hpp"
#include "World.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( AnalysisPairCorrelationUnitTest );


void AnalysisPairCorrelationUnitTest::setUp()
{
  atom *Walker = NULL;

  // init private all pointers to zero
  TestList = NULL;
  TestMolecule = NULL;
  hydrogen = NULL;
  tafel = NULL;
  correlationmap = NULL;
  binmap = NULL;

  // construct element
  hydrogen = new element;
  hydrogen->Z = 1;
  strcpy(hydrogen->name, "hydrogen");
  strcpy(hydrogen->symbol, "H");

  // construct periodentafel
  tafel = World::get()->getPeriode();
  tafel->AddElement(hydrogen);

  // construct molecule (tetraeder of hydrogens)
  TestMolecule = World::get()->createMolecule();
  Walker = World::get()->createAtom();
  Walker->type = hydrogen;
  Walker->node->Init(1., 0., 1. );
  TestMolecule->AddAtom(Walker);
  Walker = World::get()->createAtom();
  Walker->type = hydrogen;
  Walker->node->Init(0., 1., 1. );
  TestMolecule->AddAtom(Walker);
  Walker = World::get()->createAtom();
  Walker->type = hydrogen;
  Walker->node->Init(1., 1., 0. );
  TestMolecule->AddAtom(Walker);
  Walker = World::get()->createAtom();
  Walker->type = hydrogen;
  Walker->node->Init(0., 0., 0. );
  TestMolecule->AddAtom(Walker);

  // check that TestMolecule was correctly constructed
  CPPUNIT_ASSERT_EQUAL( TestMolecule->AtomCount, 4 );

  TestList = World::get()->getMolecules();
  TestMolecule->ActiveFlag = true;
  TestList->insert(TestMolecule);

  // init maps
  correlationmap = PairCorrelation( TestList, hydrogen, hydrogen );
  binmap = NULL;

};


void AnalysisPairCorrelationUnitTest::tearDown()
{
  if (correlationmap != NULL)
    delete(correlationmap);
  if (binmap != NULL)
    delete(binmap);

  // note that all the atoms are cleaned by TestMolecule
  World::destroy();
  MemoryUsageObserver::purgeInstance();
  logger::purgeInstance();
  errorLogger::purgeInstance();
};

void AnalysisPairCorrelationUnitTest::PairCorrelationTest()
{
  // do the pair correlation
  CPPUNIT_ASSERT( correlationmap != NULL );
  CPPUNIT_ASSERT_EQUAL( (size_t)6, correlationmap->size() );
};

void AnalysisPairCorrelationUnitTest::PairCorrelationBinNoRangeTest()
{
  BinPairMap::iterator tester;
  // put pair correlation into bins and check with no range
  binmap = BinData( correlationmap, 0.5, 0., 0. );
  CPPUNIT_ASSERT_EQUAL( (size_t)1, binmap->size() );
  //OutputCorrelation ( binmap );
  tester = binmap->begin();
  CPPUNIT_ASSERT_EQUAL( sqrt(2.), tester->first );
  CPPUNIT_ASSERT_EQUAL( 6, tester->second );
};

void AnalysisPairCorrelationUnitTest::PairCorrelationBinRangeTest()
{
  BinPairMap::iterator tester;
  // ... and check with [0., 2.] range
  binmap = BinData( correlationmap, 0.5, 0., 2. );
  CPPUNIT_ASSERT_EQUAL( (size_t)5, binmap->size() );
  //OutputCorrelation ( binmap );
  tester = binmap->begin();
  CPPUNIT_ASSERT_EQUAL( 0., tester->first );
  tester = binmap->find(1.);
  CPPUNIT_ASSERT_EQUAL( 1., tester->first );
  CPPUNIT_ASSERT_EQUAL( 6, tester->second );
};
