/*
 * QTMainWindow.cpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

#include "QTMainWindow.hpp"

#include<Qt/qapplication.h>
#include<Qt/qlabel.h>
#include<Qt/qstring.h>
#include<Qt/qmenubar.h>

#include<iostream>
#include<boost/bind.hpp>

#include "atom.hpp"
#include "molecule.hpp"
#include "Menu/QT4/QTMenu.hpp"
#include "Views/QT4/QTMoleculesView.hpp"


using namespace std;

QTMainWindow::QTMainWindow(menuPopulaters populaters,MoleculeListClass *molecules, config *configuration, periodentafel *periode, char *ConfigFileName,QApplication *_theApp) :
    theApp(_theApp)
{
  moleculeDisplay = new QTMoleculesView(molecules,this);
  setCentralWidget(moleculeDisplay);

  editMoleculesMenu = new QTMenu("Edit Molecules");
  populaters.MakeEditMoleculesMenu(editMoleculesMenu,molecules,configuration,periode);
  menuBar()->addMenu(editMoleculesMenu);
}

QTMainWindow::~QTMainWindow()
{
  // TODO Auto-generated destructor stub
}

void QTMainWindow::display() {
  this->show();
  theApp->exec();
}
