/*
 * config.hpp
 *
 *  Created on: Aug 3, 2009
 *      Author: heber
 */

#ifndef CONFIG_HPP_
#define CONFIG_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "bondgraph.hpp"

/****************************************** forward declarations *****************************/

class molecule;
class MoleculeListClass;
class periodentafel;

/********************************************** declarations *******************************/

class ConfigFileBuffer {
  public:
    char **buffer;
    int *LineMapping;
    int CurrentLine;
    int NoLines;

    ConfigFileBuffer();
    ConfigFileBuffer(const char * const filename);
    ~ConfigFileBuffer();

    void InitMapping();
    void MapIonTypesInBuffer(const int NoAtoms);
};

/** The config file.
 * The class contains all parameters that control a dft run also functions to load and save.
 */
class config {
  public:
    class BondGraph *BG;

    int PsiType;
    int MaxPsiDouble;
    int PsiMaxNoUp;
    int PsiMaxNoDown;
    int MaxMinStopStep;
    int InitMaxMinStopStep;
    int ProcPEGamma;
    int ProcPEPsi;
    char *configpath;
    char *configname;
    bool FastParsing;
    double Deltat;
    string basis;

    char *databasepath;

    int DoConstrainedMD;
    int MaxOuterStep;
    int Thermostat;
    int *ThermostatImplemented;
    char **ThermostatNames;
    double TempFrequency;
    double alpha;
    double HooverMass;
    double TargetTemp;
    int ScaleTempStep;

  private:
    char *mainname;
    char *defaultpath;
    char *pseudopotpath;

    int DoOutVis;
    int DoOutMes;
    int DoOutNICS;
    int DoOutOrbitals;
    int DoOutCurrent;
    int DoFullCurrent;
    int DoPerturbation;
    int DoWannier;
    int CommonWannier;
    double SawtoothStart;
    int VectorPlane;
    double VectorCut;
    int UseAddGramSch;
    int Seed;

    int OutVisStep;
    int OutSrcStep;
    int MaxPsiStep;
    double EpsWannier;

    int MaxMinStep;
    double RelEpsTotalEnergy;
    double RelEpsKineticEnergy;
    int MaxMinGapStopStep;
    int MaxInitMinStep;
    double InitRelEpsTotalEnergy;
    double InitRelEpsKineticEnergy;
    int InitMaxMinGapStopStep;

    //double BoxLength[NDIM*NDIM];

    double ECut;
    int MaxLevel;
    int RiemannTensor;
    int LevRFactor;
    int RiemannLevel;
    int Lev0Factor;
    int RTActualUse;
    int AddPsis;

    double RCut;
    int StructOpt;
    int IsAngstroem;
    int RelativeCoord;
    int MaxTypes;


  public:
  config();
  ~config();

  int TestSyntax(const char * const filename, const periodentafel * const periode) const;
  void Load(const char * const filename, const string &BondGraphFileName, const periodentafel * const periode, MoleculeListClass * const &MolList);
  void LoadOld(const char * const filename, const string &BondGraphFileName, const periodentafel * const periode, MoleculeListClass * const &MolList);
  void RetrieveConfigPathAndName(const string filename);
  bool Save(const char * const filename, const periodentafel * const periode, molecule * const mol) const;
  bool SaveMPQC(const char * const filename, const molecule * const mol) const;
  bool SavePDB(const char * const filename, const MoleculeListClass * const MolList) const;
  bool SavePDB(const char * const filename, const molecule * const mol) const;
  bool SaveTREMOLO(const char * const filename, const molecule * const mol) const;
  bool SaveTREMOLO(const char * const filename, const MoleculeListClass * const MolList) const;

  void Edit();
  bool GetIsAngstroem() const;
  char *GetDefaultPath() const;
  void SetDefaultPath(const char * const path);
  void InitThermostats();
  void ParseThermostats(class ConfigFileBuffer * const fb);
};

int ParseForParameter(const int verbose, ifstream * const file, const char * const name, const int sequential, const int xth, const int yth, const int type, void * value, const int repetition, const int critical);
int ParseForParameter(const int verbose, struct ConfigFileBuffer * const FileBuffer, const char * const name, const int sequential, const int xth, const int yth, const int type, void * value, const int repetition, const int critical);
void LoadMolecule(molecule * const &mol, struct ConfigFileBuffer * const &FileBuffer, const periodentafel * const periode, const bool FastParsing);
void PrepareFileBuffer(const char * const filename, struct ConfigFileBuffer *&FileBuffer);

#endif /* CONFIG_HPP_ */
