/*
 * NotAllAtomsAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/NotAllAtomsAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Descriptors/AtomDescriptor.hpp"
#include "atom.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionNotAllAtomsState : public ActionState {
public:
  SelectionNotAllAtomsState(std::vector<atom*> _selectedAtoms) :
    selectedAtoms(_selectedAtoms)
  {}
  std::vector<atom*> selectedAtoms;
};

const char SelectionNotAllAtomsAction::NAME[] = "unselect-all-atoms";

SelectionNotAllAtomsAction::SelectionNotAllAtomsAction() :
  Action(NAME)
{}

SelectionNotAllAtomsAction::~SelectionNotAllAtomsAction()
{}

void SelectionNotAllAtoms() {
  ActionRegistry::getInstance().getActionByName(SelectionNotAllAtomsAction::NAME)->call(Action::NonInteractive);
};

Dialog* SelectionNotAllAtomsAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryEmpty(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionNotAllAtomsAction::performCall() {
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();
  DoLog(1) && (Log() << Verbose(1) << "Unselecting all atoms." << endl);
  World::getInstance().clearAtomSelection();
  return Action::state_ptr(new SelectionNotAllAtomsState(selectedAtoms));
}

Action::state_ptr SelectionNotAllAtomsAction::performUndo(Action::state_ptr _state) {
  SelectionNotAllAtomsState *state = assert_cast<SelectionNotAllAtomsState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(new SelectionNotAllAtomsState(state->selectedAtoms));
}

Action::state_ptr SelectionNotAllAtomsAction::performRedo(Action::state_ptr _state){
  SelectionNotAllAtomsState *state = assert_cast<SelectionNotAllAtomsState*>(_state.get());

  World::getInstance().clearAtomSelection();

  return Action::state_ptr(new SelectionNotAllAtomsState(state->selectedAtoms));
}

bool SelectionNotAllAtomsAction::canUndo() {
  return true;
}

bool SelectionNotAllAtomsAction::shouldUndo() {
  return true;
}

const string SelectionNotAllAtomsAction::getName() {
  return NAME;
}
