/*
 * BreadthFirstSearchGatherer.hpp
 *
 *  Created on: May 17, 2017
 *      Author: heber
 */


#ifndef GRAPH_BREADTHFIRSTSEARCHGATHERER_HPP_
#define GRAPH_BREADTHFIRSTSEARCHGATHERER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>
#include <stddef.h>
#include <vector>

#include "types.hpp"

struct BoostGraphCreator;

/** This struct performs a BFS on a given boost::graph and finds
 * all nodes, i.e. atoms, up to a given limit.
 */
struct BreadthFirstSearchGatherer
{
  //!> typedef for the distance map to the obtained atomic id set.
  typedef std::map<atomId_t, size_t> distance_map_t;

  /** Cstor of class BreadthFirstSearchGatherer.
   *
   * \param _graph graph to work on
   */
  BreadthFirstSearchGatherer(BoostGraphCreator &_graph);

  /** Discovers all nodes from the given \a _discoverfrom and returns
   * the vector of ids.
   *
   * \param _discoverfrom node to start BFS from
   * \param _max_distance max distance to discover (0 means all)
   */
  std::vector<atomId_t> operator()(
      const atomId_t &_discoverfrom,
      const size_t &_max_distance = 0);

  /** Getter to the internal map of distances of each atomic id.
   *
   * \return ref to distance map
   */
  const distance_map_t& getDistances() const
  { return distance_map; }

private:
  //!> typedef for a vector of BFS discovery distances
  typedef std::vector<size_t> distances_t;

  //!> BFS discovery distances for the returned atomic id set
  distance_map_t distance_map;

  //!> graph to operate on
  BoostGraphCreator &BGcreator;
};


#endif /* GRAPH_BREADTHFIRSTSEARCHGATHERER_HPP_ */
