/*
 * NotMoleculeByIdAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/NotMoleculeByIdAction.hpp"
#include "molecule.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionNotMoleculeByIdState : public ActionState {
public:
  SelectionNotMoleculeByIdState(molecule* _mol) :
    mol(_mol)
  {}
  molecule* mol;
};

const char SelectionNotMoleculeByIdAction::NAME[] = "unselect-molecule-by-id";

SelectionNotMoleculeByIdAction::SelectionNotMoleculeByIdAction() :
  Action(NAME)
{}

SelectionNotMoleculeByIdAction::~SelectionNotMoleculeByIdAction()
{}

Dialog* SelectionNotMoleculeByIdAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryMolecule(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionNotMoleculeByIdAction::performCall() {
  molecule *mol = NULL;

  ValueStorage::getInstance().queryCurrentValue(NAME, mol);

  if (World::getInstance().isSelected(mol)) {
    DoLog(1) && (Log() << Verbose(1) << "Unselecting molecule " << mol->name << endl);
    World::getInstance().unselectMolecule(mol);
    return Action::state_ptr(new SelectionNotMoleculeByIdState(mol));
  } else {
    return Action::success;
  }
}

Action::state_ptr SelectionNotMoleculeByIdAction::performUndo(Action::state_ptr _state) {
  SelectionNotMoleculeByIdState *state = assert_cast<SelectionNotMoleculeByIdState*>(_state.get());

  if (state->mol != NULL)
    World::getInstance().selectMolecule(state->mol);

  return Action::state_ptr(new SelectionNotMoleculeByIdState(state->mol));
}

Action::state_ptr SelectionNotMoleculeByIdAction::performRedo(Action::state_ptr _state){
  SelectionNotMoleculeByIdState *state = assert_cast<SelectionNotMoleculeByIdState*>(_state.get());

  if (state->mol != NULL)
    World::getInstance().unselectMolecule(state->mol);

  return Action::state_ptr(new SelectionNotMoleculeByIdState(state->mol));
}

bool SelectionNotMoleculeByIdAction::canUndo() {
  return true;
}

bool SelectionNotMoleculeByIdAction::shouldUndo() {
  return true;
}

const string SelectionNotMoleculeByIdAction::getName() {
  return NAME;
}
