/*
 * MoleculeByIdAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/MoleculeByIdAction.hpp"
#include "molecule.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionMoleculeByIdState : public ActionState {
public:
  SelectionMoleculeByIdState(molecule* _mol) :
    mol(_mol)
  {}
  molecule* mol;
};

const char SelectionMoleculeByIdAction::NAME[] = "select-molecule-by-id";

SelectionMoleculeByIdAction::SelectionMoleculeByIdAction() :
  Action(NAME)
{}

SelectionMoleculeByIdAction::~SelectionMoleculeByIdAction()
{}

Dialog* SelectionMoleculeByIdAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryMolecule(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionMoleculeByIdAction::performCall() {
  molecule *mol = NULL;

  ValueStorage::getInstance().queryCurrentValue(NAME, mol);

  if (!World::getInstance().isSelected(mol)) {
    DoLog(1) && (Log() << Verbose(1) << "Selecting molecule " << mol->name << endl);
    World::getInstance().selectMolecule(mol);
    return Action::state_ptr(new SelectionMoleculeByIdState(mol));
  } else {
    return Action::success;
  }
}

Action::state_ptr SelectionMoleculeByIdAction::performUndo(Action::state_ptr _state) {
  SelectionMoleculeByIdState *state = assert_cast<SelectionMoleculeByIdState*>(_state.get());

  if (state->mol != NULL)
    World::getInstance().unselectMolecule(state->mol);

  return Action::state_ptr(new SelectionMoleculeByIdState(state->mol));
}

Action::state_ptr SelectionMoleculeByIdAction::performRedo(Action::state_ptr _state){
  SelectionMoleculeByIdState *state = assert_cast<SelectionMoleculeByIdState*>(_state.get());

  if (state->mol != NULL)
    World::getInstance().selectMolecule(state->mol);

  return Action::state_ptr(new SelectionMoleculeByIdState(state->mol));
}

bool SelectionMoleculeByIdAction::canUndo() {
  return true;
}

bool SelectionMoleculeByIdAction::shouldUndo() {
  return true;
}

const string SelectionMoleculeByIdAction::getName() {
  return NAME;
}
