/*
 * AtomByIdAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/AtomByIdAction.hpp"
#include "atom.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionAtomByIdState : public ActionState {
public:
  SelectionAtomByIdState(atom* _walker) :
    walker(_walker)
  {}
  atom* walker;
};

const char SelectionAtomByIdAction::NAME[] = "select-atom-by-id";

SelectionAtomByIdAction::SelectionAtomByIdAction() :
  Action(NAME)
{}

SelectionAtomByIdAction::~SelectionAtomByIdAction()
{}

Dialog* SelectionAtomByIdAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryAtom(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionAtomByIdAction::performCall() {
  atom *Walker = NULL;

  ValueStorage::getInstance().queryCurrentValue(NAME, Walker);

  if (!World::getInstance().isSelected(Walker)) {
    DoLog(1) && (Log() << Verbose(1) << "Selecting atom " << *Walker << endl);
    World::getInstance().selectAtom(Walker);
    return Action::state_ptr(new SelectionAtomByIdState(Walker));
  } else {
    return Action::success;
  }
}

Action::state_ptr SelectionAtomByIdAction::performUndo(Action::state_ptr _state) {
  SelectionAtomByIdState *state = assert_cast<SelectionAtomByIdState*>(_state.get());

  if (state->walker != NULL)
    World::getInstance().unselectAtom(state->walker);

  return Action::state_ptr(new SelectionAtomByIdState(state->walker));
}

Action::state_ptr SelectionAtomByIdAction::performRedo(Action::state_ptr _state){
  SelectionAtomByIdState *state = assert_cast<SelectionAtomByIdState*>(_state.get());

  if (state->walker != NULL)
    World::getInstance().selectAtom(state->walker);

  return Action::state_ptr(new SelectionAtomByIdState(state->walker));
}

bool SelectionAtomByIdAction::canUndo() {
  return true;
}

bool SelectionAtomByIdAction::shouldUndo() {
  return true;
}

const string SelectionAtomByIdAction::getName() {
  return NAME;
}
