/*
 * NotAtomByElementAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/NotAtomByElementAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Descriptors/AtomTypeDescriptor.hpp"
#include "atom.hpp"
#include "element.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionNotAtomByElementState : public ActionState {
public:
  SelectionNotAtomByElementState(std::vector<atom*> _selectedAtoms, const element *_elemental) :
    selectedAtoms(_selectedAtoms),
    elemental(_elemental)
  {}
  std::vector<atom*> selectedAtoms;
  const element *elemental;
};

const char SelectionNotAtomByElementAction::NAME[] = "unselect-atom-by-element";

SelectionNotAtomByElementAction::SelectionNotAtomByElementAction() :
  Action(NAME)
{}

SelectionNotAtomByElementAction::~SelectionNotAtomByElementAction()
{}

void SelectionNotAtomByElement(const element &_element) {
  ValueStorage::getInstance().setCurrentValue(SelectionNotAtomByElementAction::NAME, _element);
  ActionRegistry::getInstance().getActionByName(SelectionNotAtomByElementAction::NAME)->call(Action::NonInteractive);
};

Dialog* SelectionNotAtomByElementAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryElement(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionNotAtomByElementAction::performCall() {
  const element *elemental;
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();

  ValueStorage::getInstance().queryCurrentValue(NAME, elemental);

  DoLog(1) && (Log() << Verbose(1) << "Unselecting atoms of type " << *elemental << endl);
  World::getInstance().unselectAllAtoms(AtomByType(elemental));
  return Action::state_ptr(new SelectionNotAtomByElementState(selectedAtoms,elemental));
}

Action::state_ptr SelectionNotAtomByElementAction::performUndo(Action::state_ptr _state) {
  SelectionNotAtomByElementState *state = assert_cast<SelectionNotAtomByElementState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAtomByElementAction::performRedo(Action::state_ptr _state){
  SelectionNotAtomByElementState *state = assert_cast<SelectionNotAtomByElementState*>(_state.get());

  World::getInstance().unselectAllAtoms(AtomByType(state->elemental));

  return Action::state_ptr(_state);
}

bool SelectionNotAtomByElementAction::canUndo() {
  return true;
}

bool SelectionNotAtomByElementAction::shouldUndo() {
  return true;
}

const string SelectionNotAtomByElementAction::getName() {
  return NAME;
}
