/*
 * MoleculeByFormulaAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/MoleculeByFormulaAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Descriptors/MoleculeFormulaDescriptor.hpp"
#include "molecule.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionMoleculeByFormulaState : public ActionState {
public:
  SelectionMoleculeByFormulaState(std::vector<molecule*> selectedMolecules, const std::string &_formula) :
    selectedMolecules(selectedMolecules),
    formula(_formula)
  {}
  std::vector<molecule*> selectedMolecules;
  std::string formula;
};

const char SelectionMoleculeByFormulaAction::NAME[] = "select-molecule-by-formula";

SelectionMoleculeByFormulaAction::SelectionMoleculeByFormulaAction() :
  Action(NAME)
{}

SelectionMoleculeByFormulaAction::~SelectionMoleculeByFormulaAction()
{}

void SelectionMoleculeByFormula(const std::string &_formula) {
  ValueStorage::getInstance().setCurrentValue(SelectionMoleculeByFormulaAction::NAME, _formula);
  ActionRegistry::getInstance().getActionByName(SelectionMoleculeByFormulaAction::NAME)->call(Action::NonInteractive);
};

Dialog* SelectionMoleculeByFormulaAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryString(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionMoleculeByFormulaAction::performCall() {
  std::string formula;
  std::vector<molecule *> selectedMolecules = World::getInstance().getSelectedMolecules();

  ValueStorage::getInstance().queryCurrentValue(NAME, formula);

  DoLog(1) && (Log() << Verbose(1) << "Selecting molecules with chemical formula " << formula << ":" << endl);
  std::vector<molecule *> matchingMolecules = World::getInstance().getAllMolecules(MoleculeByFormula(formula));
  for (std::vector<molecule *>::const_iterator iter = matchingMolecules.begin(); iter != matchingMolecules.end(); ++iter) {
    DoLog(1) && (Log() << Verbose(1) << "\t" << (*iter)->getId() << ", " << (*iter)->getName() << "." << endl);
  }
  World::getInstance().selectAllMolecules(MoleculeByFormula(formula));
  return Action::state_ptr(new SelectionMoleculeByFormulaState(selectedMolecules,formula));
}

Action::state_ptr SelectionMoleculeByFormulaAction::performUndo(Action::state_ptr _state) {
  SelectionMoleculeByFormulaState *state = assert_cast<SelectionMoleculeByFormulaState*>(_state.get());

  World::getInstance().clearMoleculeSelection();
  for(std::vector<molecule *>::iterator iter = state->selectedMolecules.begin(); iter != state->selectedMolecules.end(); ++iter)
    World::getInstance().selectMolecule(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionMoleculeByFormulaAction::performRedo(Action::state_ptr _state){
  SelectionMoleculeByFormulaState *state = assert_cast<SelectionMoleculeByFormulaState*>(_state.get());

  World::getInstance().selectAllMolecules(MoleculeByFormula(state->formula));

  return Action::state_ptr(_state);
}

bool SelectionMoleculeByFormulaAction::canUndo() {
  return true;
}

bool SelectionMoleculeByFormulaAction::shouldUndo() {
  return true;
}

const string SelectionMoleculeByFormulaAction::getName() {
  return NAME;
}
