/*
 * AtomByElementAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/AtomByElementAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Descriptors/AtomTypeDescriptor.hpp"
#include "atom.hpp"
#include "element.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionAtomByElementState : public ActionState {
public:
  SelectionAtomByElementState(std::vector<atom*> _selectedAtoms, const element *_elemental) :
    selectedAtoms(_selectedAtoms),
    elemental(_elemental)
  {}
  std::vector<atom*> selectedAtoms;
  const element *elemental;
};

const char SelectionAtomByElementAction::NAME[] = "select-atom-by-element";

SelectionAtomByElementAction::SelectionAtomByElementAction() :
  Action(NAME)
{}

SelectionAtomByElementAction::~SelectionAtomByElementAction()
{}

void SelectionAtomByElement(const element &_element) {
  ValueStorage::getInstance().setCurrentValue(SelectionAtomByElementAction::NAME, _element);
  ActionRegistry::getInstance().getActionByName(SelectionAtomByElementAction::NAME)->call(Action::NonInteractive);
};

Dialog* SelectionAtomByElementAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryElement(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionAtomByElementAction::performCall() {
  const element *elemental;
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();

  ValueStorage::getInstance().queryCurrentValue(NAME, elemental);

  DoLog(1) && (Log() << Verbose(1) << "Selecting atoms of type " << *elemental << endl);
  World::getInstance().selectAllAtoms(AtomByType(elemental));
  return Action::state_ptr(new SelectionAtomByElementState(selectedAtoms,elemental));
}

Action::state_ptr SelectionAtomByElementAction::performUndo(Action::state_ptr _state) {
  SelectionAtomByElementState *state = assert_cast<SelectionAtomByElementState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAtomByElementAction::performRedo(Action::state_ptr _state){
  SelectionAtomByElementState *state = assert_cast<SelectionAtomByElementState*>(_state.get());

  World::getInstance().selectAllAtoms(AtomByType(state->elemental));

  return Action::state_ptr(_state);
}

bool SelectionAtomByElementAction::canUndo() {
  return true;
}

bool SelectionAtomByElementAction::shouldUndo() {
  return true;
}

const string SelectionAtomByElementAction::getName() {
  return NAME;
}
