/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * QtMoleculeView.cpp
 *
 *  Created on: Mar 4, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Views/Qt4/QtMoleculeView.hpp"

#include <iostream>
#include <QAbstractItemView>

#include "CodePatterns/MemDebug.hpp"

#include "molecule.hpp"
#include "Element/element.hpp"

using namespace std;

/***************** Basic structure for tab layout ***********/

QtMoleculeView::QtMoleculeView() :
    QTabWidget(),
    page_mol(NULL), page_atom(NULL)
{
  /*allPage = new QTAllMoleculePage();
  addTab(allPage,QString("All Molecules"));

  connect(this,SIGNAL(addMolecule(molecule*)),allPage,SLOT(addMolecule(molecule*)));
  connect(this,SIGNAL(removeMolecule(molecule*)),allPage,SLOT(removeMolecule(molecule*)));*/
}

QtMoleculeView::~QtMoleculeView()
{}

/*void QtMoleculeView::moleculeSelected(molecule *mol){
  if(!pages.count(mol)){
    string molName = mol->name;
    QTMoleculePage *molPage = new QTMoleculePage(mol,molName);
    addTab(molPage,QString(molName.c_str()));
    pages[mol] = molPage;

    connect(molPage,SIGNAL(nameChanged(QTMoleculePage*,std::string)),this,SLOT(nameChanged(QTMoleculePage*,std::string)));

    emit addMolecule(mol);
  }
}

void QtMoleculeView::moleculeUnSelected(molecule *mol){
  if(pages.count(mol)){
    QTMoleculePage *molPage = pages[mol];
    removeTab(indexOf(molPage));
    pages.erase(mol);
    delete molPage;
    emit removeMolecule(mol);
  }
}

void QtMoleculeView::nameChanged(QTMoleculePage *page, std::string name){
  setTabText(indexOf(page),QString(name.c_str()));
}*/

void QtMoleculeView::nameChanged(QTMoleculePage *page, std::string name){}

void QtMoleculeView::atomHover(const atom *_atom)
{
  // Remove old tabs.
  if (page_atom){
    removeTab(indexOf(page_atom));
    delete(page_atom);
    page_atom = NULL;
  }
  if (page_mol){
    removeTab(indexOf(page_mol));
    delete(page_mol);
    page_mol = NULL;
  }


  // Show new tabs.
  if (_atom){
    page_atom = new QTAtomPage(_atom);
    addTab(page_atom, "Atom");

    page_mol = new QTMoleculePage(_atom->getMolecule());
    addTab(page_mol, "Molecule");
  }
}

/************************ Tab for single Atoms ********************/

static void addInfo(QTreeWidget *info, const QString &key, const QString &value)
{
  QTreeWidgetItem *treeItem = new QTreeWidgetItem(info);
  treeItem->setText(0, key);
  treeItem->setText(1, value);
}

QTAtomPage::QTAtomPage(const atom *_atom) :
  Observer("QTAtomPage"),
  atomRef(_atom)
{
  atomRef->signOn(this);

  info = new QTreeWidget(this);
  info->setColumnCount(2);
  QStringList header;
  header << "data";
  header << "value";
  info->setHeaderLabels(header);

  addInfo(info, "Element", QString(atomRef->getElement().getName().c_str()));
  addInfo(info, "Mass", QString("%1").arg(atomRef->getMass()));
  addInfo(info, "Charge", QString("%1").arg(atomRef->getCharge()));
  addInfo(info, "Position", QString(toString(atomRef->getPosition()).c_str()));
  addInfo(info, "Bonds", QString("%1").arg(atomRef->getListOfBonds().size()));
}

QTAtomPage::~QTAtomPage()
{
  atomRef->signOff(this);
}

void QTAtomPage::update(Observable *subject){
  /*if(name != atomRef->name){
    name = atomRef->name;
    emit nameChanged(this,name);
  }*/
}

void QTAtomPage::subjectKilled(Observable *subject){}

/************************ Tab for single Molecules *****************/

QTMoleculePage::QTMoleculePage(const molecule *_mol) :
    Observer("QTMoleculePage"),
    mol(_mol)
{
  mol->signOn(this);

  info = new QTreeWidget(this);
  info->setColumnCount(2);
  QStringList header;
  header << "data";
  header << "value";
  info->setHeaderLabels(header);

  addInfo(info, "Name", QString(mol->getName().c_str()));
  addInfo(info, "Formula", QString(mol->getFormula().toString().c_str()));
  addInfo(info, "Atoms", QString("%1").arg(mol->getAtomCount()));
  addInfo(info, "Bonds", QString("%1").arg(mol->getBondCount()));
}

QTMoleculePage::~QTMoleculePage(){
  mol->signOff(this);
}

void QTMoleculePage::update(Observable *subject){
}

void QTMoleculePage::subjectKilled(Observable *subject){}
