/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BondLengthTableAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "bondgraph.hpp"
#include "config.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/CommandAction/BondLengthTableAction.hpp"

// and construct the stuff
#include "BondLengthTableAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr CommandBondLengthTableAction::performCall() {
  ostringstream usage;

  // obtain information
  getParametersfromValueStorage();

  DoLog(0) && (Log() << Verbose(0) << "Using " << params.BondGraphFileName << " as bond length table." << endl);
  config *configuration = World::getInstance().getConfig();
  BondGraph *OldBG;
  if (configuration->BG != NULL) {
    OldBG = configuration->BG;
    DoLog(0) && (Log() << Verbose(0) << "There is a bond length table already present." << endl);
  }
  configuration->BG = new BondGraph(configuration->GetIsAngstroem());
  if ((!params.BondGraphFileName.empty())
      && boost::filesystem::exists(params.BondGraphFileName)) {
    std::ifstream input(params.BondGraphFileName.string().c_str());
    if ((input.good()) && (configuration->BG->LoadBondLengthTable(input))) {
      DoLog(0) && (Log() << Verbose(0) << "Bond length table parsed successfully." << endl);
      input.close();
      return Action::state_ptr(new CommandBondLengthTableState(*OldBG, params));
    } else {
      DoeLog(1) && (eLog()<< Verbose(1) << "Bond length table parsing failed." << endl);
      input.close();
      configuration->BG = new BondGraph(*OldBG);
      return Action::failure;
    }
  } else {
    DoeLog(1) && (eLog()<< Verbose(1) << "Bond length table loading failed." << endl);
    configuration->BG = new BondGraph(*OldBG);
    return Action::failure;
  }
}

Action::state_ptr CommandBondLengthTableAction::performUndo(Action::state_ptr _state) {
  CommandBondLengthTableState *state = assert_cast<CommandBondLengthTableState*>(_state.get());

  config *configuration = World::getInstance().getConfig();
  BondGraph *OldBG = new BondGraph(*configuration->BG);
  configuration->BG = new BondGraph(state->OldBG);

  return Action::state_ptr(new CommandBondLengthTableState(*OldBG,params));
}

Action::state_ptr CommandBondLengthTableAction::performRedo(Action::state_ptr _state){
  CommandBondLengthTableState *state = assert_cast<CommandBondLengthTableState*>(_state.get());

  config *configuration = World::getInstance().getConfig();
  BondGraph *OldBG = new BondGraph(*configuration->BG);
  configuration->BG = new BondGraph(state->OldBG);

  return Action::state_ptr(new CommandBondLengthTableState(*OldBG,params));
}

bool CommandBondLengthTableAction::canUndo() {
  return false;
}

bool CommandBondLengthTableAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
