/*
 * RemoveSphereOfAtomsAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/RemoveSphereOfAtomsAction.hpp"
#include "atom.hpp"
#include "Descriptors/AtomDescriptor.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "vector.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char WorldRemoveSphereOfAtomsAction::NAME[] = "remove-sphere";

WorldRemoveSphereOfAtomsAction::WorldRemoveSphereOfAtomsAction() :
  Action(NAME)
{}

WorldRemoveSphereOfAtomsAction::~WorldRemoveSphereOfAtomsAction()
{}

Action::state_ptr WorldRemoveSphereOfAtomsAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  double radius = 0.;
  Vector point;

  dialog->queryDouble(NAME, &radius, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryVector("position", &point, false, MapOfActions::getInstance().getDescription("position"));

  if(dialog->display()) {
    delete dialog;
    DoLog(1) && (Log() << Verbose(1) << "Removing atoms around " << point << " with radius " << radius << "." << endl);
    vector<atom*> AllAtoms = World::getInstance().getAllAtoms();
    vector<molecule *> molecules = World::getInstance().getAllMolecules();
    for (vector<atom*>::iterator AtomRunner = AllAtoms.begin(); AtomRunner != AllAtoms.end(); ++AtomRunner) {
      if (point.DistanceSquared((*AtomRunner)->x) > radius*radius) { // distance to first above radius ...
        // TODO: This is not necessary anymore when atoms are completely handled by World (create/destroy and load/save)
        for (vector<molecule *>::iterator iter = molecules.begin();iter != molecules.end();++iter)
          (*iter)->erase(*AtomRunner);
        World::getInstance().destroyAtom(*AtomRunner);
      }
    }
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }

}

Action::state_ptr WorldRemoveSphereOfAtomsAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldRemoveSphereOfAtomsAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldRemoveSphereOfAtomsAction::canUndo() {
  return false;
}

bool WorldRemoveSphereOfAtomsAction::shouldUndo() {
  return false;
}

const string WorldRemoveSphereOfAtomsAction::getName() {
  return NAME;
}
