/*
 * ChangeBoxAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/ChangeBoxAction.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"
#include "Box.hpp"
#include "Matrix.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char WorldChangeBoxAction::NAME[] = "change-box";

WorldChangeBoxAction::WorldChangeBoxAction() :
  Action(NAME)
{}

WorldChangeBoxAction::~WorldChangeBoxAction()
{}

Action::state_ptr WorldChangeBoxAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  Box& cell_size = World::getInstance().getDomain();
  dialog->queryBox(NAME, &cell_size, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    DoLog(0) && (Log() << Verbose(0) << "Setting box domain to " << cell_size.getM() << endl);
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr WorldChangeBoxAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldChangeBoxAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldChangeBoxAction::canUndo() {
  return false;
}

bool WorldChangeBoxAction::shouldUndo() {
  return false;
}

const string WorldChangeBoxAction::getName() {
  return NAME;
}
