/*
 * CenterInBoxAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/CenterInBoxAction.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char WorldCenterInBoxAction::NAME[] = "center-in-box";

WorldCenterInBoxAction::WorldCenterInBoxAction() :
  Action(NAME)
{}

WorldCenterInBoxAction::~WorldCenterInBoxAction()
{}

Action::state_ptr WorldCenterInBoxAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  Box& cell_size = World::getInstance().getDomain();
  dialog->queryBox(NAME, &cell_size, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    // center
    vector<molecule *> AllMolecules = World::getInstance().getAllMolecules();
    for (vector<molecule*>::iterator MolRunner = AllMolecules.begin(); MolRunner != AllMolecules.end(); ++MolRunner) {
      (*MolRunner)->CenterInBox();
    }
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr WorldCenterInBoxAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldCenterInBoxAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldCenterInBoxAction::canUndo() {
  return false;
}

bool WorldCenterInBoxAction::shouldUndo() {
  return false;
}

const string WorldCenterInBoxAction::getName() {
  return NAME;
}
