/*
 * AddAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/AtomAction/AddAction.hpp"
#include "atom.hpp"
#include "element.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "vector.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char AtomAddAction::NAME[] = "add-atom";

AtomAddAction::AtomAddAction() :
  Action(NAME)
{}

AtomAddAction::~AtomAddAction()
{}

Action::state_ptr AtomAddAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  std::vector<element *> elements;
  Vector position;

  dialog->queryElement(NAME, &elements, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryVector("position", &position, true, MapOfActions::getInstance().getDescription("position"));
  cout << "pre-dialog" << endl;

  if(dialog->display()) {
    cout << "post-dialog" << endl;
    delete dialog;
    if (elements.size() == 1) {
      atom * first = World::getInstance().createAtom();
      first->type = *(elements.begin());
      first->x = position;
      DoLog(1) && (Log() << Verbose(1) << "Adding new atom with element " << first->type->name << " at " << (first->x) << "." << endl);
      // TODO: remove when all of World's atoms are stored.
      std::vector<molecule *> molecules = World::getInstance().getAllMolecules();
      if (!molecules.empty()) {
        std::vector<molecule *>::iterator iter = molecules.begin();
        (*iter)->AddAtom(first);
      }
      return Action::success;
    } else {
      DoeLog(1) && (eLog()<< Verbose(1) << "Could not find the specified element." << endl);
      return Action::failure;
    }
  } else {
    delete dialog;
    return Action::failure;
  }

}

Action::state_ptr AtomAddAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr AtomAddAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool AtomAddAction::canUndo() {
  return false;
}

bool AtomAddAction::shouldUndo() {
  return false;
}

const string AtomAddAction::getName() {
  return NAME;
}
