/*
 * FillWithMoleculeAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/FillWithMoleculeAction.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

#include "atom.hpp"
#include "bondgraph.hpp"
#include "boundary.hpp"
#include "config.hpp"
#include "defs.hpp"
#include "molecule.hpp"
#include "periodentafel.hpp"
#include "vector.hpp"
#include "verbose.hpp"
#include "World.hpp"

/****** MoleculeFillWithMoleculeAction *****/

// memento to remember the state when undoing

//class MoleculeFillWithMoleculeState : public ActionState {
//public:
//  MoleculeFillWithMoleculeState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeFillWithMoleculeAction::NAME[] = "fill-molecule";

MoleculeFillWithMoleculeAction::MoleculeFillWithMoleculeAction() :
  Action(NAME)
{}

MoleculeFillWithMoleculeAction::~MoleculeFillWithMoleculeAction()
{}

Action::state_ptr MoleculeFillWithMoleculeAction::performCall() {
  string filename;
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  Vector distances;
  Vector lengths;
  double MaxDistance = -1.;
  bool DoRotate = false;

  dialog->queryString(NAME, &filename, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryVector("distances", &distances, false, MapOfActions::getInstance().getDescription("distances"));
  dialog->queryVector("lengths", &lengths, false, MapOfActions::getInstance().getDescription("lengths"));
  dialog->queryBoolean("DoRotate", &DoRotate, MapOfActions::getInstance().getDescription("DoRotate"));
  dialog->queryDouble("MaxDistance", &MaxDistance, MapOfActions::getInstance().getDescription("MaxDistance"));

  if(dialog->display()) {
    DoLog(1) && (Log() << Verbose(1) << "Filling Box with water molecules, lengths(" << lengths[0] << "," << lengths[1] << "," << lengths[2] << "), distances (" << distances[0] << "," << distances[1] << "," << distances[2] << "), MaxDistance " << MaxDistance << ", DoRotate " << DoRotate << "." << endl);
    // construct water molecule
    molecule *filler = World::getInstance().createMolecule();
    if (!filler->AddXYZFile(filename)) {
      DoeLog(0) && (eLog()<< Verbose(0) << "Could not parse filler molecule from " << filename << "." << endl);
    }
    filler->SetNameFromFilename(filename.c_str());
    molecule *Filling = NULL;
//    atom *first = NULL, *second = NULL, *third = NULL;
//    first = World::getInstance().createAtom();
//    first->type = World::getInstance().getPeriode()->FindElement(1);
//    first->x = Vector(0.441, -0.143, 0.);
//    filler->AddAtom(first);
//    second = World::getInstance().createAtom();
//    second->type = World::getInstance().getPeriode()->FindElement(1);
//    second->x = Vector(-0.464, 1.137, 0.0);
//    filler->AddAtom(second);
//    third = World::getInstance().createAtom();
//    third->type = World::getInstance().getPeriode()->FindElement(8);
//    third->x = Vector(-0.464, 0.177, 0.);
//    filler->AddAtom(third);
//    filler->AddBond(first, third, 1);
//    filler->AddBond(second, third, 1);
    World::getInstance().getConfig()->BG->ConstructBondGraph(filler);
//    filler->SetNameFromFilename("water");
    // call routine
    double distance[NDIM];
    for (int i=0;i<NDIM;i++)
      distance[i] = distances[i];
    Filling = FillBoxWithMolecule(World::getInstance().getMolecules(), filler, *(World::getInstance().getConfig()), MaxDistance, distance, lengths[0], lengths[1], lengths[2], DoRotate);
    if (Filling != NULL) {
      Filling->ActiveFlag = false;
      World::getInstance().getMolecules()->insert(Filling);
    }
    for (molecule::iterator iter = filler->begin(); !filler->empty(); iter = filler->begin()) {
      atom *Walker = *iter;
      filler->erase(iter);
      World::getInstance().destroyAtom(Walker);
    }
    World::getInstance().destroyMolecule(filler);

    delete dialog;
    return Action::success;
  }
  delete dialog;
  return Action::failure;
}

Action::state_ptr MoleculeFillWithMoleculeAction::performUndo(Action::state_ptr _state) {
//  MoleculeFillWithMoleculeState *state = assert_cast<MoleculeFillWithMoleculeState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeFillWithMoleculeAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeFillWithMoleculeAction::canUndo() {
  return false;
}

bool MoleculeFillWithMoleculeAction::shouldUndo() {
  return false;
}

const string MoleculeFillWithMoleculeAction::getName() {
  return NAME;
}
