/*
 * BondFileAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/BondFileAction.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

#include "atom.hpp"
#include "bondgraph.hpp"
#include "config.hpp"
#include "defs.hpp"
#include "verbose.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "vector.hpp"
#include "World.hpp"

/****** MoleculeBondFileAction *****/

// memento to remember the state when undoing

//class MoleculeBondFileState : public ActionState {
//public:
//  MoleculeBondFileState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeBondFileAction::NAME[] = "bond-file";

MoleculeBondFileAction::MoleculeBondFileAction() :
  Action(NAME)
{}

MoleculeBondFileAction::~MoleculeBondFileAction()
{}

Action::state_ptr MoleculeBondFileAction::performCall() {
  string filename;
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  molecule *mol = NULL;

  dialog->queryString(NAME, &filename, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryMolecule("molecule-by-id", &mol, MapOfActions::getInstance().getDescription("molecule-by-id"));

  if(dialog->display()) {
    DoLog(0) && (Log() << Verbose(0) << "Parsing bonds from " << filename << "." << endl);
    ifstream input(filename.c_str());
    mol->CreateAdjacencyListFromDbondFile(&input);
    input.close();
    delete dialog;
    return Action::success;
  }
  delete dialog;
  return Action::failure;
}

Action::state_ptr MoleculeBondFileAction::performUndo(Action::state_ptr _state) {
//  MoleculeBondFileState *state = assert_cast<MoleculeBondFileState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeBondFileAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeBondFileAction::canUndo() {
  return false;
}

bool MoleculeBondFileAction::shouldUndo() {
  return false;
}

const string MoleculeBondFileAction::getName() {
  return NAME;
}
