/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BooleanQtQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qboxlayout.h>
#include <Qt/qcombobox.h>
#include <Qt/qlabel.h>

#include "CodePatterns/MemDebug.hpp"

#include "UIElements/Qt4/Query/QtQuery.hpp"
#include "UIElements/Qt4/Pipe/BooleanQtQueryPipe.hpp"


QtDialog::BooleanQtQuery::BooleanQtQuery(std::string _title, QBoxLayout *_parent, QtDialog *_dialog) :
    Dialog::BooleanQuery(_title),
    parent(_parent)
{
  thisLayout = new QHBoxLayout();
  titleLabel = new QLabel(QString(getTitle().c_str()),_dialog);
  booleanComboBox = new QComboBox(_dialog);
  booleanComboBox->insertItem(1, QString("true"));
  booleanComboBox->insertItem(0, QString("false"));

  parent->addLayout(thisLayout);
  thisLayout->addWidget(titleLabel);
  thisLayout->addWidget(booleanComboBox);

  pipe = new BooleanQtQueryPipe(&tmp,_dialog,booleanComboBox);
  connect(booleanComboBox, SIGNAL(currentIndexChanged()), pipe, SLOT(update()));
}

QtDialog::BooleanQtQuery::~BooleanQtQuery()
{
  delete pipe;
}

bool QtDialog::BooleanQtQuery::handle(){
  return true;
}


