/*
 * ValueStorage.hpp
 *
 *  Created on: Jul 22, 2010
 *      Author: heber
 */

#ifndef VALUESTORAGE_HPP_
#define VALUESTORAGE_HPP_


#include "Actions/MapOfActions.hpp"
#include "Patterns/Singleton.hpp"

/** ValueStorage serves as a mediator to MapOfActions.
 * This is needed to relax inter-dependencies between the Queries and the Actions.
 * I.e. this is the interface implemented in MapOfActions which both can safely rely on
 * to store&retrieve/exchange values.
 */
class ValueStorage : public Singleton<ValueStorage> {
  friend class Singleton<ValueStorage>;

public:
  template <typename T> void queryCurrentValue(const char *name, T &_T) {
    MapOfActions::getInstance().queryCurrentValue(name, _T);
  }
  template <typename T> void setCurrentValue(const char *name, T &_T) {
    MapOfActions::getInstance().setCurrentValue(name, _T);
  }

  std::string getDescription(std::string actionname);

protected:
  ValueStorage();
  ~ValueStorage();
};

#endif /* VALUESTORAGE_HPP_ */
