/*
 * QTDialog.hpp
 *
 *  Created on: Jan 18, 2010
 *      Author: crueger
 */

#ifndef QTDIALOG_HPP_
#define QTDIALOG_HPP_

#include "UIElements/Dialog.hpp"
#include <QtGui/QDialog>

class QBoxLayout;
class QLabel;
class QSpinBox;
class QDoubleSpinBox;
class QLineEdit;
class QComboBox;
class QDialogButtonBox;


// Forward declarations for plumbing
class StringQTQueryPipe;
class IntQTQueryPipe;
class DoubleQTQueryPipe;
class MoleculeQTQueryPipe;
class ElementQTQueryPipe;

class QTDialog : public QDialog, public Dialog
{
  Q_OBJECT
public:
  QTDialog();
  virtual ~QTDialog();

  virtual void queryEmpty(const char*, std::string);
  virtual void queryBoolean(const char *, bool *, std::string = "");
  virtual void queryInt(const char *, int *,std::string = "");
  virtual void queryDouble(const char*,double *,std::string = "");
  virtual void queryString(const char*, std::string *,std::string = "");
  virtual void queryStrings(const char*, std::vector<std::string> *,std::string = "");
  virtual void queryAtom(const char*,atom**,std::string = "");
  virtual void queryMolecule(const char*,molecule**,std::string = "");
  virtual void queryVector(const char*,Vector *,const double *const,bool,std::string = "");
  virtual void queryBox(const char*,double ** const, std::string = "");
  virtual void queryElement(const char*,std::vector<element *> *_target,std::string = "");

  virtual bool display();

  virtual void update();

protected:
  class IntQTQuery : public Dialog::IntQuery {
    public:
      IntQTQuery(std::string _title, int *_target,QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~IntQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QSpinBox *inputBox;

      IntQTQueryPipe *pipe;
    };

    class DoubleQTQuery : public Dialog::DoubleQuery {
    public:
      DoubleQTQuery(std::string title, double *_target,QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~DoubleQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QDoubleSpinBox *inputBox;

      DoubleQTQueryPipe *pipe;
    };

    class StringQTQuery : public Dialog::StringQuery {
    public:
      StringQTQuery(std::string _title, std::string *_target, QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~StringQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QLineEdit *inputBox;

      StringQTQueryPipe *pipe;
    };

    class StringsQTQuery : public Dialog::StringsQuery {
    public:
      StringsQTQuery(std::string _title, std::vector<std::string> *_target, QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~StringsQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QLineEdit *inputBox;

      StringQTQueryPipe *pipe;
    };

    class MoleculeQTQuery : public Dialog::MoleculeQuery {
    public:
      MoleculeQTQuery(std::string _title, molecule **_target, QBoxLayout *_parent,QTDialog *_dialog);
      virtual ~MoleculeQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *inputBox;

      MoleculeQTQueryPipe *pipe;
    };

    class VectorQTQuery : public Dialog::VectorQuery {
    public:
      VectorQTQuery(std::string title,Vector *_target,const double *const _cellSize,bool _check,QBoxLayout *,QTDialog *);
      virtual ~VectorQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *mainLayout;
      QLabel *titleLabel;
      QBoxLayout *subLayout;
      QBoxLayout *coordLayout[3];
      QLabel *coordLabel[3];
      QDoubleSpinBox *coordInput[3];

      DoubleQTQueryPipe *pipe[3];
    };

    class ElementQTQuery : public Dialog::ElementQuery {
    public:
      ElementQTQuery(std::string _title, std::vector<element *> *_target, QBoxLayout *_parent, QTDialog *_dialog);
      virtual ~ElementQTQuery();
      virtual bool handle();
    private:
      QBoxLayout *parent;
      QBoxLayout *thisLayout;
      QLabel *titleLabel;
      QComboBox *inputBox;

      ElementQTQueryPipe *pipe;
    };

private:
  QBoxLayout *mainLayout;
  QBoxLayout *inputLayout;
  QBoxLayout *buttonLayout;
  QDialogButtonBox *buttons;
};

// All kinds of plumbing for Queries
// Plumbing needs to be outside of the class where it is needed,
// since MOC doesn't like nested classes

class StringQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  StringQTQueryPipe(std::string *_content, QTDialog *_dialog);
  virtual ~StringQTQueryPipe();

public slots:
  void update(const QString&);

private:
  std::string *content;
  QTDialog *dialog;

};

class IntQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  IntQTQueryPipe(int *_content, QTDialog *_dialog);
  virtual ~IntQTQueryPipe();

public slots:
  void update(int);

private:
  int *content;
  QTDialog *dialog;

};

class DoubleQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  DoubleQTQueryPipe(double *_content, QTDialog *_dialog);
  virtual ~DoubleQTQueryPipe();

public slots:
  void update(double);

private:
  double *content;
  QTDialog *dialog;

};

class MoleculeQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  MoleculeQTQueryPipe(molecule **_content, QTDialog *_dialog, QComboBox *_theBox);
  virtual ~MoleculeQTQueryPipe();

public slots:
  void update(int);

private:
  molecule **content;
  QTDialog *dialog;
  QComboBox *theBox;

};

class ElementQTQueryPipe : public QWidget {
  Q_OBJECT
public:
  ElementQTQueryPipe(std::vector<element *> *_content, QTDialog *_dialog, QComboBox *_theBox);
  virtual ~ElementQTQueryPipe();

public slots:
  void update(int);

private:
  std::vector<element *> *content;
  QTDialog *dialog;
  QComboBox *theBox;
};
#endif /* QTDIALOG_HPP_ */
