/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FileSuffixValidator.cpp
 *
 *  Created on: May 14, 2012
 *      Author: ankele
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <boost/filesystem.hpp>
#include "FileSuffixValidator.hpp"

#include "CodePatterns/Log.hpp"

bool FileSuffixValidator::isValid(const boost::filesystem::path & _value) const
{
  const std::string dotted_suffix = std::string(".")+suffix;
  LOG(2, "DEBUG: FileSuffixValidator compares " << _value.extension() << " with " << dotted_suffix << ".");
  return _value.extension() == dotted_suffix;
}

bool FileSuffixValidator::operator==(const Validator<boost::filesystem::path> &_instance) const
{
  const FileSuffixValidator *inst =
      dynamic_cast<const FileSuffixValidator *>(&_instance);
  if (inst)
    return (suffix == inst->suffix);
  else
    return false;
}

Validator< boost::filesystem::path >* FileSuffixValidator::clone() const
{
  Validator< boost::filesystem::path > *inst =
      new FileSuffixValidator(suffix);
  return inst;
}




