/*
 * cppunuit.hpp
 *
 *  Created on: Aug 17, 2009
 *      Author: heber
 */

#ifndef VECTORUNITTEST_HPP_
#define VECTORUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

#include "vector.hpp"

/********************************************** Test classes **************************************/

class VectorTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( VectorTest) ;
    CPPUNIT_TEST ( UnityTest );
    CPPUNIT_TEST ( SimpleAlgebraTest );
    CPPUNIT_TEST ( OperatorAlgebraTest );
    CPPUNIT_TEST ( EuclidianScalarProductTest );
    CPPUNIT_TEST ( EuclidianNormTest );
    CPPUNIT_TEST ( EuclidianDistancesTest );
    CPPUNIT_TEST ( EuclidianAnglesTest );
    CPPUNIT_TEST ( ProjectionTest );
    CPPUNIT_TEST ( NormalsTest );
    CPPUNIT_TEST ( LineIntersectionTest );
    CPPUNIT_TEST ( IsInParallelepipedTest );
    CPPUNIT_TEST_SUITE_END();

public:
    void setUp();
    void tearDown();

    void UnityTest();
    void OperatorAlgebraTest();
    void SimpleAlgebraTest();
    void EuclidianScalarProductTest();
    void EuclidianNormTest();
    void EuclidianDistancesTest();
    void EuclidianAnglesTest();
    void ProjectionTest();
    void NormalsTest();
    void LineIntersectionTest();
    void VectorRotationTest();
    void IsInParallelepipedTest();

private:
    // vector to execute tests on, may be modified during run
    Vector fixture;
    // never modify these during run, other tests might rely on them
    Vector zero;
    Vector unit;
    Vector otherunit;
    Vector notunit;
    Vector two;
    Vector three;
};


#endif /* VECTORUNITTEST_HPP_ */
