/*
 * Line.hpp
 *
 *  Created on: Apr 30, 2010
 *      Author: crueger
 */

#ifndef LINE_HPP_
#define LINE_HPP_

#include "Space.hpp"

#include <memory>
#include <vector>

class Vector;

class Line : public Space
{
public:
  Line(const Vector &_origin, const Vector &_direction);
  Line(const Line& _src);
  virtual ~Line();

  virtual double distance(const Vector &point) const;
  virtual Vector getClosestPoint(const Vector &point) const;

  Vector getDirection() const;
  Vector getOrigin() const;

  std::vector<Vector> getPointsOnLine() const;

  Vector getIntersection(const Line& otherLine) const;

  Vector rotateVector(const Vector &rhs, double alpha) const;

private:
  std::auto_ptr<Vector> origin;
  std::auto_ptr<Vector> direction;
};

/**
 * Named constructor to make a line through two points
 */
Line makeLineThrough(const Vector &x1, const Vector &x2);

#endif /* LINE_HPP_ */
