/*
 * CreatorStub.hpp
 *
 *  Created on: Jan 4, 2011
 *      Author: heber
 */

#ifndef CREATORSTUB_HPP_
#define CREATORSTUB_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <typeinfo>

#include "CodePatterns/Creator.hpp"

class ICreatorStub {
public:
  virtual ~ICreatorStub() {};
  virtual void count() = 0;
  virtual int getcount() = 0;
  virtual std::string name() = 0;
};


template <class T>
class CreatorStub : public ICreatorStub, public Creator<ICreatorStub, CreatorStub<T> >
{
public:
  CreatorStub() {};
  virtual ~CreatorStub() {};

  virtual void count() {
    member.counter++;
  }
  virtual int getcount() {
    return member.counter;
  }
  virtual std::string name() {
    return std::string(typeid(T).name());
  }
private:
  T member;
};


#endif /* CREATORSTUB_HPP_ */
