/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2017 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * NotAtomByNameAction.cpp
 *
 *  Created on: May 12, 2017
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomNameDescriptor.hpp"
#include "Descriptors/AtomSelectionDescriptor.hpp"
#include "Atom/atom.hpp"
#include "Element/element.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

#include "NotAtomByNameAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "NotAtomByNameAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr SelectionNotAtomByNameAction::performCall() {
  LOG(1, "Unselecting atoms of name " << params.atomname.get());
  std::vector<const atom *> unselectedAtoms = const_cast<const World &>(World::getInstance()).
      getAllAtoms(!AtomsBySelection());
  World::getInstance().unselectAllAtoms(AtomByName(params.atomname.get()));
  LOG(0, World::getInstance().countSelectedAtoms() << " atoms remain selected.");
  return ActionState::ptr(new SelectionNotAtomByNameState(unselectedAtoms,params));
}

ActionState::ptr SelectionNotAtomByNameAction::performUndo(ActionState::ptr _state) {
  SelectionNotAtomByNameState *state = assert_cast<SelectionNotAtomByNameState*>(_state.get());

  World::getInstance().selectAllAtoms(AtomByName(state->params.atomname.get()));
  BOOST_FOREACH(const atom *_atom, state->unselectedAtoms)
    World::getInstance().unselectAtom(_atom);

  return ActionState::ptr(_state);
}

ActionState::ptr SelectionNotAtomByNameAction::performRedo(ActionState::ptr _state){
  SelectionNotAtomByNameState *state = assert_cast<SelectionNotAtomByNameState*>(_state.get());

  World::getInstance().unselectAllAtoms(AtomByName(state->params.atomname.get()));

  return ActionState::ptr(_state);
}

bool SelectionNotAtomByNameAction::canUndo() {
  return true;
}

bool SelectionNotAtomByNameAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
