/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2017 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * AtomByNameAction.cpp
 *
 *  Created on: May 12, 2017
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomNameDescriptor.hpp"
#include "Descriptors/AtomSelectionDescriptor.hpp"
#include "Atom/atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

#include "AtomByNameAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "AtomByNameAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr SelectionAtomByNameAction::performCall() {
  LOG(1, "Selecting atoms of name " << params.atomname.get());
  std::vector<const atom *> selectedAtoms =
      const_cast<const World &>(World::getInstance()).getAllAtoms(AtomsBySelection());
  World::getInstance().selectAllAtoms(AtomByName(params.atomname.get()));
  LOG(0, World::getInstance().countSelectedAtoms() << " atoms selected.");
  return ActionState::ptr(new SelectionAtomByNameState(selectedAtoms,params));
}

ActionState::ptr SelectionAtomByNameAction::performUndo(ActionState::ptr _state) {
  SelectionAtomByNameState *state = assert_cast<SelectionAtomByNameState*>(_state.get());

  World::getInstance().unselectAllAtoms(AtomByName(state->params.atomname.get()));
  BOOST_FOREACH(const atom *_atom, state->selectedAtoms)
    World::getInstance().selectAtom(_atom);

  return ActionState::ptr(_state);
}

ActionState::ptr SelectionAtomByNameAction::performRedo(ActionState::ptr _state){
  SelectionAtomByNameState *state = assert_cast<SelectionAtomByNameState*>(_state.get());

  World::getInstance().selectAllAtoms(AtomByName(state->params.atomname.get()));

  return ActionState::ptr(_state);
}

bool SelectionAtomByNameAction::canUndo() {
  return true;
}

bool SelectionAtomByNameAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
