/*
 * Woodcock.hpp
 *
 *  Created on: Aug 20, 2010
 *      Author: crueger
 */

#ifndef WOODCOCK_HPP_
#define WOODCOCK_HPP_

#include "Thermostats/Thermostat.hpp"

class Woodcock : public Thermostat
{
public:
  Woodcock(int);
  Woodcock();
  virtual ~Woodcock();

  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::list) atoms);
  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::vector) atoms);
  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::set) atoms);

  virtual std::string name();

  virtual std::string writeParams();

private:
  template <class ForwardIterator>
  double doScaleAtoms(unsigned int step,double ActualTemp,ForwardIterator begin,ForwardIterator end);

  int ScaleTempStep;
};

template <>
struct ThermostatTraits<class Woodcock> : public ThermostatTraits<Thermostat>
{
  ThermostatTraits();
  virtual Thermostat *make(class ConfigFileBuffer * const fb);
  const char* name;
};

#endif /* WOODCOCK_HPP_ */
