/*
 * NoseHoover.hpp
 *
 *  Created on: Aug 20, 2010
 *      Author: crueger
 */

#ifndef NOSEHOOVER_HPP_
#define NOSEHOOVER_HPP_

#include "Thermostats/Thermostat.hpp"

class NoseHoover : public Thermostat
{
public:
  NoseHoover(double _HooverMass);
  NoseHoover();
  virtual ~NoseHoover();

  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::list) atoms);
  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::vector) atoms);
  virtual double scaleAtoms(unsigned int step,double ActualTemp,ATOMSET(std::set) atoms);

  virtual std::string name();
  virtual std::string writeParams();

private:
  template <class ForwardIterator>
  void init(unsigned int step,ForwardIterator begin, ForwardIterator end);
  template <class ForwardIterator>
  double doScaleAtoms(unsigned int step,double ActualTemp,ForwardIterator begin, ForwardIterator end);

  double HooverMass;
  double delta_alpha;
  double alpha;
  int count;
};

template <>
struct ThermostatTraits<class NoseHoover> : public ThermostatTraits<Thermostat>
{
  ThermostatTraits();
  virtual Thermostat *make(class ConfigFileBuffer * const fb);
  const char* name;
};


#endif /* NOSEHOOVER_HPP_ */
