/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ScaleBoxAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "atom.hpp"
#include "CodePatterns/Log.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"
#include "Box.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/WorldAction/ScaleBoxAction.hpp"

// and construct the stuff
#include "ScaleBoxAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr WorldScaleBoxAction::performCall() {
  double x[NDIM];

  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Scaling all atomic positions by factor." << endl);
  for (int i=0;i<NDIM;i++)
    x[i] = params.Scaler[i];
  vector<atom*> AllAtoms = World::getInstance().getAllAtoms();
  for(vector<atom*>::iterator AtomRunner = AllAtoms.begin(); AtomRunner != AllAtoms.end(); ++AtomRunner) {
    (*AtomRunner)->ScaleAll(x);
  }

  RealSpaceMatrix M = World::getInstance().getDomain().getM();
  RealSpaceMatrix scale;

  for (int i=0;i<NDIM;i++) {
    scale.at(i,i) = x[i];
  }
  M *= scale;
  World::getInstance().setDomain(M);

  // give final box size
  LOG(0, "Box domain is now " << World::getInstance().getDomain().getM());

  return Action::success;
}

Action::state_ptr WorldScaleBoxAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldScaleBoxAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldScaleBoxAction::canUndo() {
  return false;
}

bool WorldScaleBoxAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
