/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AddEmptyBoundaryAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "atom.hpp"
#include "CodePatterns/Log.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "World.hpp"

#include <iostream>
#include <string>
#include <vector>

using namespace std;

#include "Actions/WorldAction/AddEmptyBoundaryAction.hpp"

// and construct the stuff
#include "AddEmptyBoundaryAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr WorldAddEmptyBoundaryAction::performCall() {
  Vector Min;
  Vector Max;
  int j=0;

  // obtain information
  getParametersfromValueStorage();

  // get maximum and minimum
  vector<atom *> AllAtoms = World::getInstance().getAllAtoms();
  ASSERT(AllAtoms.size() > 0, "There must be atoms present for AddingEmptyBoundary.");
  vector<atom *>::iterator AtomRunner = AllAtoms.begin();
  Min = (*AtomRunner)->getPosition();
  Max = (*AtomRunner)->getPosition();
  for (; AtomRunner != AllAtoms.end(); ++AtomRunner) {
    for (int i=0;i<NDIM;i++) {
      if ((*AtomRunner)->at(i) > Max[i])
        Max[i] = (*AtomRunner)->at(i);
      if ((*AtomRunner)->at(i) < Min[i])
        Min[i] = (*AtomRunner)->at(i);
    }
  }
  // set new box size
  double * const cell_size = new double[6];
  for (j=0;j<6;j++)
    cell_size[j] = 0.;
  j=-1;
  for (int i=0;i<NDIM;i++) {
    j += i+1;
    cell_size[j] = (Max[i]-Min[i]+2.*params.boundary[i]);
  }
  World::getInstance().setDomain(cell_size);
  delete[] cell_size;
  // translate all atoms, such that Min is aty (0,0,0)
  AtomRunner = AllAtoms.begin();
  for (; AtomRunner != AllAtoms.end(); ++AtomRunner)
    *(*AtomRunner) -= Min - params.boundary;

  // give final box size
  LOG(0, "Box domain is now " << World::getInstance().getDomain().getM());

  return Action::success;
}

Action::state_ptr WorldAddEmptyBoundaryAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldAddEmptyBoundaryAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldAddEmptyBoundaryAction::canUndo() {
  return false;
}

bool WorldAddEmptyBoundaryAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
