/*
 * InfoUnitTest.cpp
 *
 *  Created on: Nov 25, 2009
 *      Author: heber
 */

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <iostream>
#include <stdio.h>

#include "info.hpp"
#include "infounittest.hpp"

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( InfoTest );


void InfoTest::setUp()
{
};


void InfoTest::tearDown()
{
};

/** UnitTest for FunctionTest().
 */
void InfoTest::FunctionTest()
{
  const char *msg = __func__;
  class Info test(msg);

  CPPUNIT_ASSERT_EQUAL( msg , test.FunctionName );
  CPPUNIT_ASSERT_EQUAL( 1, test.verbosity );
};


/********************************************** Main routine **************************************/

int main(int argc, char **argv)
{
  // Get the top level suite from the registry
  CppUnit::Test *suite = CppUnit::TestFactoryRegistry::getRegistry().makeTest();

  // Adds the test to the list of test to run
  CppUnit::TextUi::TestRunner runner;
  runner.addTest( suite );

  // Change the default outputter to a compiler error format outputter
  runner.setOutputter( new CppUnit::CompilerOutputter( &runner.result(),
                                                       std::cerr ) );
  // Run the tests.
  bool wasSucessful = runner.run();

  // Return error code 1 if the one of test failed.
  return wasSucessful ? 0 : 1;
};
