/*
 * NotAllAtomsOfMoleculeAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/SelectionAction/NotAllAtomsOfMoleculeAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Descriptors/AtomDescriptor.hpp"
#include "atom.hpp"
#include "molecule.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"


// memento to remember the state when undoing

class SelectionNotAllAtomsOfMoleculeState : public ActionState {
public:
  SelectionNotAllAtomsOfMoleculeState(std::vector<atom*> _selectedAtoms, molecule *_mol) :
    selectedAtoms(_selectedAtoms),
    mol(_mol)
  {}
  std::vector<atom*> selectedAtoms;
  molecule *mol;
};

const char SelectionNotAllAtomsOfMoleculeAction::NAME[] = "unselect-molecules-atoms";

SelectionNotAllAtomsOfMoleculeAction::SelectionNotAllAtomsOfMoleculeAction() :
  Action(NAME)
{}

SelectionNotAllAtomsOfMoleculeAction::~SelectionNotAllAtomsOfMoleculeAction()
{}

void SelectionNotAllAtomsOfMolecule() {
  ActionRegistry::getInstance().getActionByName(SelectionNotAllAtomsOfMoleculeAction::NAME)->call(Action::NonInteractive);
};

Dialog* SelectionNotAllAtomsOfMoleculeAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryMolecule(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr SelectionNotAllAtomsOfMoleculeAction::performCall() {
  molecule *mol = NULL;
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();

  ValueStorage::getInstance().queryCurrentValue(NAME, mol);

  DoLog(1) && (Log() << Verbose(1) << "Unselecting all atoms of molecule " << mol->getName() << "." << endl);
  World::getInstance().unselectAtomsOfMolecule(mol);
  return Action::state_ptr(new SelectionNotAllAtomsOfMoleculeState(selectedAtoms, mol));
}

Action::state_ptr SelectionNotAllAtomsOfMoleculeAction::performUndo(Action::state_ptr _state) {
  SelectionNotAllAtomsOfMoleculeState *state = assert_cast<SelectionNotAllAtomsOfMoleculeState*>(_state.get());

  World::getInstance().clearAtomSelection();
  for(std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter)
    World::getInstance().selectAtom(*iter);

  return Action::state_ptr(new SelectionNotAllAtomsOfMoleculeState(state->selectedAtoms, state->mol));
}

Action::state_ptr SelectionNotAllAtomsOfMoleculeAction::performRedo(Action::state_ptr _state){
  SelectionNotAllAtomsOfMoleculeState *state = assert_cast<SelectionNotAllAtomsOfMoleculeState*>(_state.get());

  World::getInstance().unselectAtomsOfMolecule(state->mol);

  return Action::state_ptr(new SelectionNotAllAtomsOfMoleculeState(state->selectedAtoms, state->mol));
}

bool SelectionNotAllAtomsOfMoleculeAction::canUndo() {
  return true;
}

bool SelectionNotAllAtomsOfMoleculeAction::shouldUndo() {
  return true;
}

const string SelectionNotAllAtomsOfMoleculeAction::getName() {
  return NAME;
}
