/*
 * GLWorldScene.hpp
 *
 *  This is based on the Qt3D example "teaservice", specifically parts of teaservice.cpp.
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLWORLDSCENE_HPP_
#define GLWORLDSCENE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qobject.h>

#include "molecule.hpp"

class atom;

class QGLPainter;
class QGLSceneNode;
class QGLView;

class GLMoleculeObject;
class GLMoleculeObject_atom;
class GLMoleculeObject_bond;

/** This class contains a list of all molecules in the world.
 *
 */
class GLWorldScene : public QObject
{
  Q_OBJECT
public:
  GLWorldScene(QObject *parent=0);
  virtual ~GLWorldScene();

//#if !defined(QT_OPENGL_ES_1)
//  PerPixelEffect *lighting;
//#endif

  void changeMaterials(bool perPixel);
  QGLSceneNode* getAtom(size_t);
  QGLSceneNode* getBond(size_t, size_t);

  void initialize(QGLView *view, QGLPainter *painter) const;
  void draw(QGLPainter *painter) const;

signals:
  void changed();
  void pressed();
  void released();
  void clicked();
  void clicked(atomId_t);
  void doubleClicked();
  void hoverChanged();

private slots:
  void atomClicked(atomId_t no);
  void atomInserted(const atom *_atom);
  void atomRemoved(const atom *_atom);
  void bondsChanged(const atom *_atom);

private:
  void init();
  void bondInserted(const bond *_bond);
  void bondRemoved(const atomId_t leftnr, const atomId_t rightnr);

  typedef std::pair< atomId_t, atomId_t> BondIds;
  typedef std::map< atomId_t, GLMoleculeObject_atom* > AtomNodeMap;
  typedef std::map< BondIds , GLMoleculeObject_bond* > BondNodeMap;
  typedef std::multimap< atomId_t, atomId_t > BondIdsMap;
  AtomNodeMap AtomsinSceneMap;
  BondIdsMap BondIdsinSceneMap;
  BondNodeMap BondsinSceneMap;
};



#endif /* GLWORLDSCENE_HPP_ */
