/*
 * Dialog_impl_pre.hpp
 *
 *  Created on: May 17, 2015
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/preprocessor/cat.hpp>
#include <boost/preprocessor/comparison/equal.hpp>
#include <boost/preprocessor/debug/assert.hpp>
#include <boost/preprocessor/iteration/local.hpp>
#include <boost/preprocessor/seq/size.hpp>

// check if no sequences given
#ifndef GLOBALLISTOFPARAMETERQUERIES_Token
#define MAXPARAMETERTOKENS 0
#else
#define MAXPARAMETERTOKENS BOOST_PP_SEQ_SIZE(GLOBALLISTOFPARAMETERQUERIES_Token)
#endif
// check that both sequences have same size
#ifdef GLOBALLISTOFPARAMETERQUERIES_Type
BOOST_PP_ASSERT_MSG(BOOST_PP_EQUAL(MAXPARAMETERTOKENS, BOOST_PP_SEQ_SIZE(GLOBALLISTOFPARAMETERQUERIES_Type)),\
  ERROR: There are not the same number of "GLOBALLISTOFPARAMETERQUERIES_Token" and "GLOBALLISTOFPARAMETERQUERIES_Type" in: __FILE__ \
)
#endif

// print a virtual function definition. SUFFIX is a "global" define
#define dialog_declaration(z,n,TOKENLIST,TYPELIST) \
  virtual void \
  BOOST_PP_CAT(query, BOOST_PP_SEQ_ELEM(n, TOKENLIST)) \
  (Parameter< \
      BOOST_PP_SEQ_ELEM(n, TYPELIST) \
  > &, const std::string ="", const std::string = "") \
  SUFFIX \
  ;


// print a class forward declaration
#define forward_declaration(z,n,TOKENLIST,CLASSSUFFIX) \
    class \
    BOOST_PP_CAT(BOOST_PP_SEQ_ELEM(n, TOKENLIST), CLASSSUFFIX) \
    ;

// print a query class definition
#define queryclass_definition(z,n,TOKENLIST,TYPELIST, CLASSSUFFIX) \
    class \
    BOOST_PP_CAT(CLASSSUFFIX, Dialog::) \
    BOOST_PP_CAT(BOOST_PP_CAT(BOOST_PP_SEQ_ELEM(n, TOKENLIST), CLASSSUFFIX), Query) \
    : public Dialog::TQuery< \
      BOOST_PP_SEQ_ELEM(n, TYPELIST) \
    > { \
    public: \
      BOOST_PP_CAT(BOOST_PP_CAT(BOOST_PP_SEQ_ELEM(n, TOKENLIST), CLASSSUFFIX), Query) \
      (Parameter< \
            BOOST_PP_SEQ_ELEM(n, TYPELIST) \
          > &_param, const std::string &_title, const std::string &_description = ""); \
      virtual ~\
      BOOST_PP_CAT(BOOST_PP_CAT(BOOST_PP_SEQ_ELEM(n, TOKENLIST), CLASSSUFFIX), Query) \
      (); \
      virtual bool handle(); \
    };

