/*
 * atom_observable.hpp
 *
 *  Created on: Sep 1, 2011
 *      Author: heber
 */

#ifndef ATOM_OBSERVABLE_HPP_
#define ATOM_OBSERVABLE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Observer/Channels.hpp"
#include "CodePatterns/Observer/Observable.hpp"

#include <map>

/** This class encapsulates Observable pattern along with required notification
 *  types.
 */
class AtomObservable : public Observable
{
public:
  enum NotificationType {
    PositionChanged,  // position (at current step) of atom changed
    VelocityChanged,  // velocity (at current step) of atom changed
    ForceChanged,     // force (at current step) of atom changed
    NameChanged,      // name of atom changed
    ElementChanged,   // element changed
    IndexChanged,     // index (getId()) changed
    PropertyChanged,  // some other property changed
    BondsAdded,       // new bonds have appeared on ListOfBonds
    BondsRemoved,       // new bonds have appeared on ListOfBonds
    NotificationType_MAX  // denotes the maximum of available notification types
  };

  AtomObservable();
  virtual ~AtomObservable();
};


#endif /* ATOM_OBSERVABLE_HPP_ */
