/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SaveAdjacencyAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "bondgraph.hpp"
#include "config.hpp"
#include "CodePatterns/Log.hpp"
#include "molecule.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"


#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "Actions/MoleculeAction/SaveAdjacencyAction.hpp"

// and construct the stuff
#include "SaveAdjacencyAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeSaveAdjacencyAction::performCall() {
  molecule *mol = NULL;

  // obtain information
  getParametersfromValueStorage();

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(0) && (Log() << Verbose(0) << "Storing adjacency to path " << params.adjacencyfile << "." << endl);
    // TODO: sollte stream nicht filename benutzen, besser fuer unit test
    mol->StoreAdjacencyToFile(params.adjacencyfile.leaf(), params.adjacencyfile.branch_path().string());
  }
  return Action::success;
}

Action::state_ptr MoleculeSaveAdjacencyAction::performUndo(Action::state_ptr _state) {
//  MoleculeSaveAdjacencyState *state = assert_cast<MoleculeSaveAdjacencyState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeSaveAdjacencyAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSaveAdjacencyAction::canUndo() {
  return false;
}

bool MoleculeSaveAdjacencyAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
