/*
 * ActOnAllUnitTest.cpp
 *
 *  Created on: 04.10.2009
 *      Author: FrederikHeber
 */

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "../test/ActOnAlltest.hpp"
#include "ActOnAllUnitTest.hpp"
#include "vector.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ActOnAllTest );


void ActOnAllTest::setUp()
{
  Vector *temp = NULL;
  // fill list with vectors
  temp = new Vector(1,0,0);
  VL.AddVector(temp);
  temp = new Vector(0,1,0);
  VL.AddVector(temp);
  temp = new Vector(0,0,1);
  VL.AddVector(temp);
  Ref = VL;
};


void ActOnAllTest::tearDown()
{
  VL.EmptyList();
  // Ref was copy constructed, hence has to be cleaned, too!
  Ref.EmptyList();
};

/** UnitTest for VectorList::ActOnAll() and Vector::AddVector(), Vector::SubtractVector(),
 */
void ActOnAllTest::AddSubtractTest()
{
  const Vector test(1.,0.,0.);

  // adding, subtracting
  VL.ActOnAll( &Vector::AddVector, test );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , false );
  VL.ActOnAll( &Vector::SubtractVector, test );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , true );
};

/** UnitTest for VectorList::ActOnAll()
 */
void ActOnAllTest::ScaleTest()
{
  double factor=2.;
  double inverse=1./2.;

  // scaling by value
  VL.ActOnAll( (void (Vector::*)(const double)) &Vector::Scale, factor );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , false );

  VL.ActOnAll( (void (Vector::*)(const double)) &Vector::Scale, inverse );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , true );

  // scaling by three values
  double *factors = new double[NDIM];
  double *inverses = new double[NDIM];
  for (int i=0;i<NDIM;++i) {
    factors[i] = 2.;
    inverses[i] = 1./factors[i];
  }
  VL.ActOnAll<Vector,void,const double*>(&Vector::ScaleAll, factors );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , false );

  VL.ActOnAll<Vector,void,const double*>(&Vector::ScaleAll, inverses );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , true );
  delete[](factors);
  delete[](inverses);
};

#if 0

// Unitttest deactivated for now...
// Reasons:
//    Vector::MakeNormalVector has been removed and is now part of Plane class
//    VectorList::ActOnAll is in the test directory and seems to be used only for unittests
//    MakeNormal never depended on the input Vector except in the case of linear dependence (i.e. failure)
//
// TODO: Rethink what exactely is being tested at this point and introduce a new unittest for the
//       tested behaviour. Most likely this should result in a thourough unittest of the plane class

/** UnitTest for VectorList::ActOnAll() and Vector::MakeNormalVector()
 */
void ActOnAllTest::NormalizeTest()
{
  const Vector xaxis(1.,0.,0.);
  const Vector yaxis(0.,1.,0.);

  // normalize with respect to x and y axis
  bool (Vector::*f)(const Vector *, const Vector *) = &Vector::MakeNormalVector;
  VL.ActOnAll( f, &xaxis, &yaxis );
  CPPUNIT_ASSERT_EQUAL( VL == Ref , false );

  // check that x and y components are zero
  for (ListOfVectors::iterator Runner = VL.Vectors.begin(); Runner != VL.Vectors.end(); Runner++) {
    CPPUNIT_ASSERT_EQUAL( (*Runner)->at(0) , 0. );
    CPPUNIT_ASSERT_EQUAL( (*Runner)->at(1) , 0. );
  }
};

#endif
