/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SetTremoloAtomdataAction.cpp
 *
 *  Created on: Aug 9, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Parser/TremoloParser.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem/fstream.hpp>

#include "SetTremoloAtomdataAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SetTremoloAtomdataAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr ParserSetTremoloAtomdataAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  FormatParser<tremolo> &parser = FormatParserStorage::getInstance().getParser<tremolo>();

  DoLog(1) && (Log() << Verbose(1) << "Setting Tremolo's ATOMDATA to: '" << params.atomdata_string << "'" << std::endl);

  parser.setAtomData(params.atomdata_string);

  return Action::success;
}

Action::state_ptr ParserSetTremoloAtomdataAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr ParserSetTremoloAtomdataAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool ParserSetTremoloAtomdataAction::canUndo() {
  return false;
}

bool ParserSetTremoloAtomdataAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
