/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ParseTremoloPotentialsAction.cpp
 *
 *  Created on: Feb 9, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Parser/TremoloParser.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem/fstream.hpp>

#include "ParseTremoloPotentialsAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "ParseTremoloPotentialsAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr ParserParseTremoloPotentialsAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  boost::filesystem::ifstream test;
  FormatParser<tremolo> &parser = FormatParserStorage::getInstance().getParser<tremolo>();
  // parsing file if present
  if (!boost::filesystem::exists(params.filename)) {
    DoLog(1) && (Log() << Verbose(1) << "Specified potentials file " << params.filename << " not found." << endl);
    // DONT FAIL: it's just empty we re-create default id-mapping
    parser.createKnownTypesByIdentity();

  } else {
    DoLog(1) && (Log() << Verbose(1) << "Specified potentials file found, parsing ... " << std::endl);

    // parse the file
    test.open(params.filename);
    parser.parseKnownTypes(test);
    test.close();
  }

  return Action::success;
}

Action::state_ptr ParserParseTremoloPotentialsAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr ParserParseTremoloPotentialsAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool ParserParseTremoloPotentialsAction::canUndo() {
  return false;
}

bool ParserParseTremoloPotentialsAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
