/*
 * QSeisPlotPage.cpp
 *
 *  Created on: Jan 30, 2011
 *      Author: landvogt
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtGui/QHBoxLayout>
#include <QtGui/QListView>
#include <QtGui/QListWidgetItem>

#include "UIElements/Views/Qt4/Plotting/QSeisPlotPage.hpp"
#include "UIElements/Views/Qt4/Plotting/QSeisPlot.hpp"
#include "UIElements/Views/Qt4/Plotting/QListWidgetCurveItem.hpp"
#include "UIElements/Views/Qt4/Plotting/QSeisPlotCurve.hpp"
#include "UIElements/Views/Qt4/Plotting/QSeisCurveRegistry.hpp"

// have this after(!) all Qt includes
#include "CodePatterns/MemDebug.hpp"

QSeisPlotPage::QSeisPlotPage(QString type, QWidget *parent) :
        QWidget(parent), plotType(type)
{
    //create GUI elements
    QHBoxLayout *layout = new QHBoxLayout(this);
    curveList = new QListWidget(this);
    curveList->setMaximumWidth(250);
    plot = new QSeisPlot(this,type);
    layout->addWidget(curveList);
    layout->addWidget(plot);
    setLayout(layout);

    connect(curveList, SIGNAL(itemChanged(QListWidgetItem*)), this, SLOT(listItemChanged(QListWidgetItem*)));
}

QSeisPlotPage::~QSeisPlotPage()
{

}

std::string QSeisPlotPage::getName()
{
    return plotType.toStdString();
}

void QSeisPlotPage::resetPlot()
{
    plot->resetPlot();
}

void QSeisPlotPage::addCurve(std::string name)
{
    QSeisPlotCurve *curve;
    QListWidgetCurveItem *item;
    curve = QSeisCurveRegistry::getInstance().getByName(name);

    item = new QListWidgetCurveItem();
    item->curveName = curve->getName();
    item->setText(curve->getDisplayName());

    if (curve->plot() != NULL)
        item->setCheckState(Qt::Checked);
    else
        item->setCheckState(Qt::Unchecked);

    curveList->addItem((QListWidgetItem *)item);
}

void QSeisPlotPage::updateCurve(std::string name)
{
    QSeisPlotCurve *curve;
    curve = QSeisCurveRegistry::getInstance().getByName(name);
    if (curve->plot() != NULL)
        curve->plot()->replot();
}

void QSeisPlotPage::removeCurve(std::string name)
{
    QSeisPlotCurve *curve;
    QListWidgetCurveItem *item;
    curve = QSeisCurveRegistry::getInstance().getByName(name);

    for (int i = 0; i < curveList->count(); i++)
    {
        item = (QListWidgetCurveItem *)curveList->item(i);
        if (item->curveName == name)
        {
            curveList->takeItem(i);
            delete item;
            return;
        }
    }
}

void QSeisPlotPage::listItemChanged(QListWidgetItem *item)
{
    QListWidgetCurveItem *curveItem = (QListWidgetCurveItem *)item;
    QSeisPlotCurve *curve;
    curve = QSeisCurveRegistry::getInstance().getByName(curveItem->curveName);

    if (curveItem->checkState() == Qt::Unchecked)
    {
        if (curve->plot() != NULL)
        {
            curve->detach();
            //be carefull - changing the text color triggers this slot!
            curveItem->setTextColor(QColor(Qt::black));
        }
    }
    else if (curveItem->checkState() == Qt::Checked)
    {
        if (curve->plot() == NULL)
        {
            curve->attach(plot);
            //be carefull - changing the text color triggers this slot!
            curveItem->setTextColor(curve->pen().color());
        }
    }

    plot->replot();
    plot->resetZoomer();
}
